from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from cars.core.pusher import BasePusher

from cars.core.constants import AppPlatform
from cars.core.solomon import SOLOMON
from ..core.push_client import PUSH_CLIENT
from .base import DriveAPIView


class PushDebugView(DriveAPIView):

    pusher = BasePusher.from_settings(
        push_client=PUSH_CLIENT,
        solomon_client=SOLOMON,
    )

    def do_post(self, request):
        if push_token is None:
            return Response(
                status=HTTP_400_BAD_REQUEST,
                data={
                    'errors': ['push_token.missing'],
                },
            )

        if app_name is None:
            return Response(
                status=HTTP_400_BAD_REQUEST,
                data={
                    'errors': ['app_name.missing'],
                },
            )

        message = request.data.get('message')
        payload = request.data.get('payload')
        if message is None and payload is None:
            return Response(
                status=HTTP_400_BAD_REQUEST,
                data={
                    'errors': ['message_or_payload.missing'],
                },
            )

        self.pusher.subscribe(
            uid=request.user.uid,
            uuid=app_install.uuid,
            platform=AppPlatform(app_install.platform),
            app_name=app_install.app_name,
            push_token=push_token,
        )
        self.pusher.send(
            uid=request.user.uid,
            message=message,
            payload=payload,
            sender=request.user,
        )

        return Response()
