import logging
import time

from rest_framework.response import Response

from cars.django.util import ReqAnsLogger
from cars.users.models.user import User
from ..core.plus_status_updater import IntroScreensUpdater
from ..serializers.intro import IntroSerializer
from .base import DriveAPIView


LOGGER = logging.getLogger(__name__)


class IntroView(DriveAPIView):

    reqans_logger_policy = ReqAnsLogger.Policy.FULL

    def do_get(self, request):
        updater = IntroScreensUpdater.from_settings(request.user)
        updater.maybe_update_user_plus_status()
        updater.maybe_update_porsche_status()

        try:
            self._maybe_update_user_staff_tags(request.user)
        except Exception:
            LOGGER.exception('unable to update staff tags')

        request.user.refresh_from_db()

        request.user = (
            User.objects
            .select_related(
                'bonus_account',
                'credit_card',
                'introscreens',
            )
            .get(id=request.user.id)
        )
        data = IntroSerializer(request).data
        return Response(data)

    def _maybe_update_user_staff_tags(self, user):
        """
        Temporary workaround until regular process on user tags is fixed.
        """
        if user.is_yandexoid:
            tags = user.tags or []
            is_changed = False
            if 'yandex_stuff' not in tags:
                tags.append('yandex_stuff')
                is_changed = True
            if 'yandex_staff' not in tags:
                tags.append('yandex_staff')
                is_changed = True
            if is_changed:
                user.tags = tags
                user.updated_at = time.time()
                user.save()
