import logging
import time

from django.db import transaction
from django.utils import timezone
from rest_framework.response import Response

from cars.django.util import ReqAnsLogger
from cars.users.models.user_intro_screens import UserIntroScreens
from .base import DriveAPIView


LOGGER = logging.getLogger(__name__)


class IntroScreensView(DriveAPIView):

    reqans_logger_policy = ReqAnsLogger.Policy.FULL

    def do_post(self, request):
        screen_type = request.GET.get('screen', '<not specified>').lower()

        with transaction.atomic(savepoint=False):
            introscreens = request.user.introscreens
            if introscreens is None:
                request.user.introscreens = UserIntroScreens()
                request.user.updated_at = time.time()
                request.user.save()
            if screen_type == 'plus':
                request.user.introscreens.plus_screen_viewed_at = timezone.now()
            elif screen_type == 'porsche':
                request.user.introscreens.porsche_screen_viewed_at = timezone.now()
            else:
                LOGGER.error('unknown introscreen type: %s', screen_type)
            request.user.introscreens.save()

        return Response()

