from rest_framework.response import Response

from cars.users.core.user_profile_updater import UserProfileUpdater
from .base import DriveAPIView


class UserPlusPromoConfirmationView(DriveAPIView):

    def do_post(self, request):
        updater = UserProfileUpdater(user=request.user)
        updater.mark_plus_landing_viewed()

        return Response({
            'status': 'success',
            'errors': None,
        })


class UserPlusPromoTextView(DriveAPIView):

    def do_get(self, request):  # pylint:disable=unused-argument
        if request.user.get_plus_status():
            response_json = {
                'plus': {
                    'title': 'Яндекс.Плюс подключен',
                    'body': 'Наслаждайтесь благами:',
                    'button': 'Это прекрасно',
                    'points': [
                        '5% скидка на все поездки',
                        '25 минут бесплатной брони',
                        'ночное бесплатное ожидание с 23:30 до 6:00'
                    ],
                }
            }
        else:
            response_json = {}

        return Response(response_json)
