import logging

from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from cars.core.authorization import (
    ExternalAuthenticationFactory, ExternalAuthenticationAPIView,
)
from cars.core.sender import SenderClient

import cars.settings

from ..serializers.promo_karaoke import KaraokePromoViewArgumentsSerializer

LOGGER = logging.getLogger(__name__)


class KaraokePromoWebHookAPIView(ExternalAuthenticationAPIView):
    CAMPAIGN = 'C16RGBJ3-IAI1'
    SALT = '2c41d3f2-c5e2-4032-8dea-43b315531119'

    authentication_classes = [
        ExternalAuthenticationFactory.build(
            token=cars.settings.REQUEST_AGGREGATOR['audiotele']['robot_auth_token'],
            salt=SALT,
        )
    ]

    arguments_serializer_class = KaraokePromoViewArgumentsSerializer

    def do_post(self, request):
        sender = SenderClient(
            url_template=cars.settings.SENDER['url_template'],
            token=cars.settings.SENDER['token']
        )

        try:
            email = request.arguments['email']
            args = {
                'discount': request.arguments['discount'],
                'name': request.arguments['promo_code']
            }
            sender.send(campaign=self.CAMPAIGN, to_email=email, args=args, async=True)

        except Exception as exc:
            error_message = str(exc)
            LOGGER.error(error_message)
            return Response(error_message, status=HTTP_400_BAD_REQUEST)

        return Response()
