import logging

from rest_framework.response import Response

from cars.django.util import ReqAnsLogger
from cars.drive.serializers.user_consents import UserConsentsViewArgumentsSerializer
from cars.users.core import UserProfileUpdater
from .base import DriveAPIView


LOGGER = logging.getLogger(__name__)


class UserConsentsView(DriveAPIView):

    arguments_serializer_class = UserConsentsViewArgumentsSerializer
    reqans_logger_policy = ReqAnsLogger.Policy.FULL

    def do_post(self, request):
        updater = UserProfileUpdater(user=request.user)
        updater.update_persdata_processing_consent(
            consent_type=request.arguments['consent_type'],
            consent_value=request.arguments['consent_value'],
        )
        return Response()
