from rest_framework.response import Response

import cars.settings
from cars.users.core.user_profile_updater import UserProfileUpdater
from cars.core.util import import_class
from ..core.push_client import PUSH_CLIENT
from ..serializers.user_credit_card import UserCreditCardViewArgumentsSerializer
from .base import DriveAPIView


class UserCreditCardView(DriveAPIView):

    arguments_serializer_class = UserCreditCardViewArgumentsSerializer

    def do_post(self, request):
        trust_client_class = import_class(cars.settings.TRUST['client_class'])
        updater = UserProfileUpdater(
            user=request.user,
            trust_client=trust_client_class.from_settings(push_client=PUSH_CLIENT),
            push_client=PUSH_CLIENT,
        )

        try:
            updater.update_credit_card(
                paymethod_id=request.arguments['paymethod_id'],
            )
        except updater.CreditCardNotBound:
            return Response({
                'status': 'errors',
                'errors': ['credit_card.not_bound'],
            })

        return Response({
            'status': 'success',
            'errors': None,
        })
