from rest_framework.response import Response

from cars.users.core.user_profile_updater import UserProfileUpdater
from ..core.push_client import PUSH_CLIENT
from ..serializers.user_email import UserEmailViewArgumentsSerializer
from .base import DriveAPIView


class UserEmailView(DriveAPIView):

    arguments_serializer_class = UserEmailViewArgumentsSerializer

    def do_post(self, request):
        updater = UserProfileUpdater(
            user=request.user,
            push_client=PUSH_CLIENT,
        )

        try:
            updater.update_email(email=request.arguments['email'])
        except UserProfileUpdater.ValidationError:
            return Response({
                'status': 'errors',
                'errors': ['email.invalid'],
            })
        except UserProfileUpdater.ConflictError:
            return Response({
                'status': 'errors',
                'errors': ['email.exists'],
            })

        return Response({
            'status': 'success',
            'errors': None,
        })
