from django.db.models import F
from rest_framework.mixins import ListModelMixin

from cars.django.pagination import Pagination
from cars.fines.models import AutocodeFine
from cars.orders.core.order_payment_processor import OrderPaymentProcessor
from ..serializers.fine import FineSerializer
from .base import DriveAPIView
from cars.django.views import CarsharingAPIView
from cars.core.saas_drive import SaasDrive
from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST
import cars.settings


class UserFinesView(CarsharingAPIView):
    permission_classes = []  # backend provides authorization instead

    if 'testing' not in cars.settings.SAAS_DRIVE['url']:
        _url = 'https://prestable.carsharing.yandex.net'
    else:
        _url = 'https://testing.carsharing.yandex.net'

    saas_drive = SaasDrive.from_settings(url=_url)

    def do_get(self, request, *args, **kwargs):
        try:
            fines = self.saas_drive.get_fines(request)
        except Exception:
            return Response([], status=HTTP_400_BAD_REQUEST)
        else:
            for fine in fines:
                fine['sum_to_pay'] /= 100.
                fine['sum_to_pay_without_discount'] /= 100.
            return Response(fines)
