import logging

from rest_framework.response import Response

import cars.settings
from cars.core.pusher import BasePusher
from cars.core.solomon import SOLOMON
from cars.users.core.app_install_updater import AppInstallUpdater
from cars.users.core.user_profile_updater import UserProfileUpdater
from cars.users.serializers import UserSerializer
from ..core.push_client import PUSH_CLIENT
from ..serializers.user_session import UserSessionViewArgumentsSerializer
from .base import DriveAPIView


LOGGER = logging.getLogger(__name__)


class UserSessionView(DriveAPIView):

    arguments_serializer_class = UserSessionViewArgumentsSerializer

    pusher = BasePusher.from_settings(
        push_client=PUSH_CLIENT,
        solomon_client=SOLOMON,
    )

    def do_post(self, request):
        user_updater = UserProfileUpdater(
            user=request.user,
            push_client=PUSH_CLIENT,
        )
        if request.user.is_yandexoid != request.yauser.is_yandexoid():
            user_updater.update_is_yandexoid(request.yauser.is_yandexoid())

        platform = request.arguments['platform']

        """
        app_install_updater = AppInstallUpdater(
            user=request.user,
            push_client=PUSH_CLIENT,
        )
        app_install = app_install_updater.update(
            uuid=request.arguments['uuid'],
            device_id=request.arguments['device_id'],
            platform=platform,
            app_name=cars.settings.XIVA[platform]['app_name'],
            app_version=request.arguments['app_version'],
            app_build=request.arguments['app_build'],
            push_token=request.arguments['push_token'],
        )

        if app_install.app_name and app_install.push_token:
            try:
                self.pusher.subscribe(
                    uid=request.user.uid,
                    uuid=app_install.uuid,
                    platform=app_install.get_platform(),
                    app_name=app_install.app_name,
                    push_token=app_install.push_token,
                )
            except Exception:
                LOGGER.exception(
                    'failed to subscribe user %s to push notifications',
                    request.user.id,
                )

        data = UserSerializer(request.user).data

        return Response(data)
        """

        data = None
        return Response(data)
