from cars.core.daemons import CarsharingDaemon
from ..core.processor import BonusAccountUpdater


class BonusAccountUpdaterDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._updater = BonusAccountUpdater.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'eka/locks/bonus_account_updater.lock'

    def get_solomon_sensor_prefix(self):
        return 'eka.bonus_account_updater'

    def get_solomon_service(self):
        return 'eka'

    def _do_tick(self):
        self._updater.assign_bonuses_for_users()
