from cars.core.daemons import CarsharingDaemon
from ..core.processor import ExpiredActivationsBlocker


class FuelCardBlockerDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._blocker = ExpiredActivationsBlocker.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'eka/locks/fuel_card_blocker.lock'

    def get_solomon_sensor_prefix(self):
        return 'eka.fuel_card_blocker'

    def get_solomon_service(self):
        return 'eka'

    def _do_tick(self):
        self._blocker.block_expired_fuel_cards()
