from cars.core.daemons import CarsharingDaemon
from ..core.processor import FuelLevelVerifier


class FuelLevelVerifierDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._verifier = FuelLevelVerifier.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'eka/locks/fuel_level_verifier.lock'

    def get_solomon_sensor_prefix(self):
        return 'eka.fuel_level_verifier'

    def get_solomon_service(self):
        return 'eka'

    def _do_tick(self):
        self._verifier.scan_fuel_level_from_recently_fueled_cars()
