from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyFloat, FuzzyText

from ..models.gas_station import GasStation


class GasStationFactory(DjangoModelFactory):

    class Meta:
        model = GasStation

    name = FuzzyText()

    latitude = FuzzyFloat(low=32, high=35)
    longitude = FuzzyFloat(low=50, high=56)

    fuel_types = [
        '92',
        '95',
    ]

    address = FuzzyText()
