import enum
import uuid

from django.db import models

from cars.billing.models.bonus_account import BonusAccountOperation
from cars.carsharing.models import Car
from cars.orders.models import Order
from cars.users.models import User


class FuelCardActivation(models.Model):

    class Source(enum.Enum):
        MOBILE_APP = 'mobile_app'
        ADMIN_PORTAL = 'admin_portal'
        INTERNAL_CC = 'internal_cc'
        EXTERNAL_CC = 'external_cc'
        ROBOT_AUTO = 'robot_auto'

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    order = models.ForeignKey(
        Order,
        related_name='fuel_card_activations',
        on_delete=models.CASCADE,
        null=True,
    )
    car = models.ForeignKey(
        Car,
        related_name='fuel_card_activations',
        on_delete=models.CASCADE,
        null=True,
    )

    activated_at = models.DateTimeField()
    activated_by = models.ForeignKey(
        User,
        related_name='fuel_card_activations',
        on_delete=models.CASCADE,
        null=True,
    )
    activated_via = models.TextField(
        max_length=12,
        choices=[(x.value, x.name) for x in Source],
        null=True,
    )

    blocked_at = models.DateTimeField(null=True)
    blocked_by = models.ForeignKey(
        User,
        related_name='fuel_card_blockings',
        on_delete=models.CASCADE,
        null=True,
    )
    blocked_via = models.TextField(
        max_length=12,
        choices=[(x.value, x.name) for x in Source],
        null=True,
    )

    initial_fuel_level = models.FloatField(default=0.0)
    eventual_fuel_level = models.FloatField(default=0.0)

    bonus_account_operation = models.OneToOneField(
        BonusAccountOperation,
        on_delete=models.CASCADE,
        null=True,
    )
