import uuid

from django.contrib.postgres.fields import ArrayField
from django.db import models

from cars.carsharing.models import CarModel


class GasStation(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)
    name = models.CharField(max_length=256)
    logo = models.CharField(max_length=256, null=True)

    latitude = models.FloatField()
    longitude = models.FloatField()

    address = models.CharField(max_length=512)
    fuel_types = ArrayField(
        models.CharField(
            max_length=2,
            choices=[(x.value, x.name) for x in CarModel.FuelTypes],
        )
    )

    class Meta:
        db_table = 'eka_gas_station'
