from rest_framework.serializers import ModelSerializer, SerializerMethodField

from ..models import GasStation


class GasStationSerializer(ModelSerializer):

    location = SerializerMethodField()

    class Meta:
        model = GasStation
        fields = [
            'id',
            'name',
            'logo',
            'address',
            'fuel_types',
            'location',
        ]

    def get_location(self, obj):
        return [obj.longitude, obj.latitude]
