from django.conf.urls import url

from . import views


app_name = 'eka'
urlpatterns = [
    # gas stations list
    url(
        r'^gas-stations/$',
        views.GasStationsListView.as_view(),
        name='gas-stations-list',
    ),

    # fuel card actions
    url(
        r'^fuel-cards/activate/$',
        views.FuelCardActivateView.as_view(),
        name='fuel-card-activate',
    ),
    url(
        r'^fuel-cards/block/$',
        views.FuelCardBlockView.as_view(),
        name='fuel-card-block',
    ),
    url(
        r'^fuel-cards/update-number/$',
        views.FuelCardNumberUpdateView.as_view(),
        name='fuel-card-update-number',
    ),

    # telematics actions
    url(
        r'^car/open/$',
        views.CarOpenDoorsView.as_view(),
        name='car-open',
    ),
    url(
        r'^car/close/$',
        views.CarCloseDoorsView.as_view(),
        name='car-close',
    ),
]
