from rest_framework.response import Response

from cars.django.views import CarsharingAPIView
from ..models import GasStation
from ..serializers import GasStationSerializer


class GasStationsListView(CarsharingAPIView):

    def get_queryset(self):
        return GasStation.objects

    def do_get(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        return Response(GasStationSerializer(self.get_queryset(), many=True).data)
