# -*- coding: utf-8 -*-

from os import environ
from os.path import join
from copy import deepcopy

if environ.get('DJANGO_SETTINGS_MODULE') is not None:
    from kubiki import distributed_lock
    from cars import settings
    from cars.core.daemons import CarsharingDaemon
    from cars.core.util import make_yt_client
    from cars.core.solomon import make_solomon_client
else:
    class CarsharingDaemon(object):
        pass


# Yt bugfix
import packaging
import packaging.version
import packaging.specifiers
import packaging.requirements


class YtCronJob(CarsharingDaemon):
    # Try to update large table three times a day
    tick_interval = '0 4,12,20 * * *'

    transaction_timeout = 1000 * 60 * 60 * 6
    #                     ^ms    ^s   ^m   ^h

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._yt = make_yt_client('data')

    @property
    def code(self):
        raise NotImplementedError(
            'You should assign \'code\' an unique value'
        )

    def get_distributed_lock_relative_path(self):
        return 'data/_locks/{}.lock'.format(self.code)

    def get_solomon_service(self):
        return 'exports'

    def get_solomon_sensor_prefix(self):
        return 'exports.{}'.format(self.code)

    def get_distributed_lock(self):
        locks_config = deepcopy(settings.EXPORT['locks_config'])
        locks_config['path'] = join(
            locks_config.pop('base_dir'),
            self.get_distributed_lock_relative_path()
        )
        return distributed_lock.YtLock(**locks_config)

    def make_solomon_client(self):
        solomon_config = deepcopy(settings.SOLOMON)
        solomon_config['service'] = self.get_solomon_service()
        solomon_config['project'] = settings.EXPORT['solomon_project']
        solomon = make_solomon_client(config=solomon_config)
        return solomon

    def _do_tick(self):
        raise NotImplementedError()
