# -*- coding: utf-8 -*-

from logging import getLogger
from datetime import datetime, timedelta


LOGGER = getLogger(__name__)


class HealthcheckJob(YtCronJob):
    code = 'healthcheck'

    tick_interval = '30 * * * *'

    def _do_tick(self):
        self._now = datetime.utcnow()
        self._day = self._now.replace(
            hour=0,
            minute=0,
            second=0,
            microsecond=0,
        )
        self._check_users_export()
        self._check_orders_export()

    def _check_users_export(self):
        pass

    def _check_orders_export(self):
        # Check orders directory last state
        last_state = self._parse_day(self._yt.get_attribute(
            '{}/{}'.format(
                settings.EXPORT['home_directory'],
                Orders.ORDERS_DIR
            ),
            '_last_state'
        ))
        self.solomon.set_value(
            '{}.orders.last_state'.format(self.get_solomon_sensor_prefix()),
            int((self._day - last_state).total_seconds())
        )

    @staticmethod
    def _parse_day(day_str):
        return (
            datetime.strptime(day_str, '%Y-%m-%d')
            .replace(
                hour=0,
                minute=0,
                second=0,
                microsecond=0,
            )
        )
