# -*- coding: utf-8 -*-

import logging
from datetime import datetime, timedelta
from cars import settings
from .cron_job import YtCronJob
from ..exports import RefundIssuesHistoryExport


LOGGER = logging.getLogger(__name__)


class RefundIssuesExportJob(YtCronJob):
    code = 'refund_issues'

    def _do_tick(self):
        refund_issues_table = RefundIssuesHistoryExport(self._yt)
        refund_issues_table.export(settings.EXPORT['table_refund_issues_history'])
