# -*- coding: utf-8 -*-

import os
import time
import yt.wrapper
from datetime import datetime, timedelta
from cars import settings
from .table_export import TableExport

# Yt bugfix
import packaging
import packaging.version
import packaging.specifiers
import packaging.requirements

# Yt should not fail now
if os.environ.get('DJANGO_SETTINGS_MODULE') is not None:
    from django.core.exceptions import ObjectDoesNotExist
    from cars.fines.models import AutocodeFine


def _merger(key, rows):
    for row in rows:
        yield row


def _reducer(key, rows):
    fines = {}
    for row in rows:
        row_id = row['id']
        if row_id in fines:
            fines[row_id]['total_cost_fine'] += row['total_cost_fine']
            fines[row_id]['total_paid_fine'] += row['total_paid_fine']
            fines[row_id]['total_count_of_fines'] += row['total_count_of_fines']
        else:
            fines[row_id] = row
    for fine in fines.values():
        if fine['id']:
            yield fine


class AutocodeFineExport(TableExport):
    @classmethod
    def _get_all_query_set(cls, finish):
        return (
            AutocodeFine.objects
            .using(settings.DB_RO_ID)
        )

    def _save_table(self, path):
        self._yt.run_sort(
            source_table=path,
            destination_table=path,
            sort_by=['id'],
        )
        self._yt.run_reduce(
            _reducer,
            source_table=path,
            destination_table=path,
            reduce_by=['id'],
        )

    def _export_all(self, path, finish):
        super()._export_all(path, finish)
        self._save_table(path)

    def _export_delta(self, path, start, finish):
        super()._export_all(path, finish)
        self._save_table(path)

    @classmethod
    def _get_finish(cls):
        return int(time.time()) - 60 * 5

    def _get_columns(self):
        return {
            'id':                   ('user_id',    self._to_string),
            'total_cost_fine':      ('sum_to_pay', float),
            'total_count_of_fines': ('user_id',    self._get_count_one),
        }

    def _get_row_extra(self, obj):
        total_paid_fine = float()
        if obj.charge_passed_at:
            total_paid_fine = float(obj.sum_to_pay)
        return {
            'total_paid_fine': total_paid_fine,
        }

    @classmethod
    def _get_merge_columns(cls):
        return ['id']

    @classmethod
    def _get_merger(cls):
        return _merger

    @staticmethod
    def _get_count_one(value):
        return 1
