# -*- coding: utf-8 -*-

import os
import time
from yt.wrapper import with_context
from datetime import datetime, timedelta
from cars import settings
from .table_export import TableExport

# Yt bugfix
import packaging
import packaging.version
import packaging.specifiers
import packaging.requirements

# Yt should not fail now
if os.environ.get('DJANGO_SETTINGS_MODULE') is not None:
    from django.core.exceptions import ObjectDoesNotExist
    from cars.billing.models import RefundIssuesHistory


@with_context
def _table_merger(key, rows, context):
    result = {}
    for row in rows:
        row_id = row['history_event_id']
        if context.table_index == 1:
            result[row_id] = row
        elif row_id not in result:
            result[row_id] = row
    for row in result.values():
        yield row


class RefundIssuesHistoryExport(TableExport):
    @classmethod
    def _get_all_query_set(cls, finish):
        return (
            RefundIssuesHistory.objects
            .using(settings.DB_RO_ID)
            .filter(
                history_timestamp__lt=finish,
            )
        )

    @classmethod
    def _get_delta_query_set(cls, start, finish):
        return (
            RefundIssuesHistory.objects
            .using(settings.DB_RO_ID)
            .filter(
                history_timestamp__gte=start,
                history_timestamp__lt=finish,
            )
        )

    @classmethod
    def _get_finish(cls):
        return int(time.time()) - 60 * 5

    def _get_columns(self):
        return {
            'history_event_id': ('history_event_id', int),
            'history_user_id': ('history_user_id', self._to_string),
            'history_action': ('history_action', self._to_string),
            'history_timestamp': ('history_timestamp', int),
            'history_comment': ('history_comment', self._to_string),
            'payment_id': ('payment_id', self._to_string),
            'session_id': ('session_id', self._to_string),
            'user_id': ('user_id', self._to_string),
            'sum': ('sum', float),
        }

    @classmethod
    def _get_schema(cls):
        return [
            {'name': 'history_event_id',  'type': 'int64'},
            {'name': 'history_user_id',   'type': 'string'},
            {'name': 'history_action',    'type': 'string'},
            {'name': 'history_timestamp', 'type': 'int64'},
            {'name': 'history_comment',   'type': 'string'},
            {'name': 'payment_id',        'type': 'string'},
            {'name': 'session_id',        'type': 'string'},
            {'name': 'user_id',           'type': 'string'},
            {'name': 'sum',               'type': 'double'},
        ]

    @classmethod
    def _get_merge_columns(cls):
        return ['history_event_id']

    @classmethod
    def _get_merger(cls):
        return _table_merger
