# -*- coding: utf-8 -*-

import hmac
import binascii
from hashlib import sha1
from cars import settings


def hash_personal_data(data):
    if not isinstance(data, bytes):
        data = data.encode('utf-8')
    out = hmac.new(settings.DOCS_HASHES_KEY, data, sha1)
    result_bytes = out.digest()
    return binascii.hexlify(result_bytes).decode('utf-8')


def normalize_personal_data(data):
    return data.strip().replace(' ', '').lower()


def hash_user_name(name):
    if name is None:
        return None
    name = normalize_personal_data(name)
    return hash_personal_data(name)


def hash_passport_parts(number, subdiv):
    if number is None or subdiv is None:
        return None
    data = normalize_personal_data(subdiv + number)
    return hash_personal_data(data)
