# -*- coding: utf-8 -*-

from cars import settings
from cars.export.yt import Table


class CarTag(object):
    def __init__(self, *args, **kwargs):
        self.event_id = kwargs['event_id']
        self.timestamp = kwargs['timestamp']
        self.car_id = kwargs['car_id']
        self.user_id = kwargs['user_id']
        self.tag = kwargs['tag']
        self.action = kwargs['action']
        self.data = kwargs['data'] or {}
        self.snapshot = kwargs['snapshot'] or {}


class CarTagsHistory(Table):
    def __init__(self, day):
        self._day = day

    def _row_to_value(self, row):
        return CarTag(
            event_id=int(row['history_event_id']),
            timestamp=int(row['history_timestamp']),
            car_id=row['object_id'],
            user_id=row['history_user_id'],
            tag=row['tag'],
            action=row['history_action'],
            data=row.get('unpacked_data', {}),
            snapshot=row.get('unpacked_snapshot', {}),
        )

    def _get_path(self):
        return '{}/{}'.format(
            settings.EXPORT['home_directory'],
            self._day.strftime('car_tags_history/%Y-%m-%d'),
        )
