# -*- coding: utf-8 -*-

from yt.wrapper import TablePath


# Yt bugfix
import packaging
import packaging.version
import packaging.specifiers
import packaging.requirements


class YtTable(object):
    def __init__(self, yt):
        self._yt = yt

    def update(self):
        yield NotImplementedError()

    def invalidate(self):
        self.set_last_state(None)

    def get_name(self):
        yield NotImplementedError()

    def get_schema(self):
        yield NotImplementedError()

    def get_index(self):
        yield NotImplementedError()

    def get_table_path(self):
        return TablePath(
            name=self.get_name(),
            schema=self.get_schema(),
        )

    def get_last_state(self, default=None):
        return self._yt.get_attribute(
            path=self.get_table_path(),
            attribute='_last_state',
            default=default,
        )

    def set_last_state(self, state):
        self._yt.set_attribute(
            path=self.get_table_path(),
            attribute='_last_state',
            value=state,
        )
