import hammock
import requests


class Hammock(hammock.Hammock):
    """Chainable, magical class helps you make requests to RESTful services.
    The name is just a joke, as is Hammock."""

    def _request(self, method, *args, **kwargs):
        """ Makes the HTTP request.

        Raises:
            HttpError: If an error occurred while handling http request or status code .
        """
        response = super(Hammock, self)._request(method, *args, **kwargs)
        try:
            response.raise_for_status()
        except requests.exceptions.HTTPError:
            raise requests.exceptions.HTTPError(
                'Bad response status: {}. Content: `{}`'.format(
                    response.status_code, response.content)
            )

        return response
