import os

import requests.auth

import cars.ext.hammock
from . import (
    assignments, operations, pools, projects, requester, skills, task_suites, tasks, user_restrictions, user_skills,
)


__all__ = ['Client']


class Auth(requests.auth.AuthBase):
    def __init__(self, token):
        self.token = token

    def __call__(self, r):
        r.headers['Authorization'] = 'OAuth {token}'.format(token=self.token)
        return r


class Client(object):
    """ This class handles user authentication and common requests."""

    def __init__(self, oauth_token, uri, verify='/etc/ssl/certs/ca-certificates.crt'):
        """ Initialized a client instance.

        Args:
            oauth_token (str): A token obtained from the Toloka API.
            uri (str): An url (a scheme and a host) to Toloka you are using.
        """
        if not os.path.exists(verify):
            verify = False
        uri = cars.ext.hammock.Hammock(uri.rstrip('/'), auth=Auth(oauth_token), verify=verify)
        self._root = uri.api.v1

        self.assignments = assignments.Resource(self._root)
        self.operations = operations.Resource(self._root)
        self.pools = pools.Resource(self._root)
        self.projects = projects.Resource(self._root)
        self.requester = requester.Resource(self._root)
        self.skills = skills.Resource(self._root)
        self.task_suites = task_suites.Resource(self._root)
        self.tasks = tasks.Resource(self._root)
        self.user_restrictions = user_restrictions.Resource(self._root)
        self.user_skills = user_skills.Resource(self._root)
