from . import Collection
from .. import utils


class Creatable(Collection):
    create_method = 'POST'

    def create(self, **data):
        """ Creates a new instance. """
        action = getattr(self.uri, self.create_method)
        response = action(json=utils.prepare_json(data), params=self.params)
        return self.entity_class(
            **response.json()
        )
