from . import base
from .base import entities


class Resource(base.Resource):
    def __init__(self, api_root):
        super(Resource, self).__init__(
            uri=api_root.operations,
            collection_class=Collection,
            item_class=Item,
            entity_class=Entity,
        )


class Collection(base.Collection):
    pass


class Item(base.Item):
    def log(self):
        """ See https://tech.yandex.ru/toloka/api/doc/concepts/get-operation-log-docpage/ """
        return tuple(
            base.Entity(element)
            for element in self.uri.log.GET().json()
        )


class Entity(entities.Datable, base.Entity):
    DATE_FIELDS = [
        'submitted',
        'started',
        'finished',
    ]
