from . import base
from . import operations
from .base import collections
from .base import entities
from .base import items


class Resource(base.Resource):
    def __init__(self, api_root):
        super(Resource, self).__init__(
            uri=api_root.pools,
            collection_class=Collection,
            item_class=Item,
            entity_class=Entity,
        )


class Collection(collections.Creatable, base.Collection):
    pass


class Item(items.Editable, base.Item):
    def open(self):
        """ Makes pool's task suites available for users (opens the pool). """
        return operations.Entity(
            **self.uri.open.POST().json()
        )

    def close(self):
        """ Makes pool's task suites not available for users (closes the pool). """
        return operations.Entity(
            **self.uri.close.POST().json()
        )

    def clone(self):
        """ Creates new pool with settings of this pool """
        return operations.Entity(
            **self.uri.clone.POST().json()
        )

    def archive(self):
        """ Sends this pool to the archive. """
        return operations.Entity(
            **self.uri.archive.POST().json()
        )


class Entity(entities.Datable, base.Entity):
    DATE_FIELDS = [
        'created',
        'will_expire',
        'last_started',
        'last_stopped',
    ]
