from . import base
from . import operations
from .base import collections
from .base import entities
from .base import items


class Resource(base.Resource):
    def __init__(self, api_root):
        super(Resource, self).__init__(
            uri=api_root.projects,
            collection_class=Collection,
            item_class=Item,
            entity_class=Entity,
        )


class Collection(collections.Creatable, base.Collection):
    pass


class Item(items.Editable, base.Item):
    def archive(self):
        """ Archives a project.

        Notes:
            All the project's pools must be already archived.
        """
        return operations.Entity(
            **self.uri.archive.POST().json()
        )


class Entity(entities.Datable, base.Entity):
    DATE_FIELDS = ['created']
