from . import base
from .base import entities
from . import tasks


class Resource(base.Resource):
    def __init__(self, api_root):
        super(Resource, self).__init__(
            uri=getattr(api_root, 'task-suites'),
            collection_class=Collection,
            item_class=Item,
            entity_class=Entity,
        )


class Collection(tasks.Collection):
    pass


class Item(base.Item):
    pass


class Entity(entities.Datable, base.Entity):
    DATE_FIELDS = ['created']
