from . import base
from . import operations
from . import utils
from .base import collections
from .base import entities


class Resource(base.Resource):
    def __init__(self, api_root):
        super(Resource, self).__init__(
            uri=getattr(api_root, 'tasks'),
            collection_class=Collection,
            item_class=Item,
            entity_class=Entity,
        )


class Collection(collections.Creatable, base.Collection):
    def create(self, *args, **data):
        if args:
            return self.create_multiple(*args)
        else:
            return super(Collection, self).create(**data)

    def create_multiple(self, *args):
        """ See https://tech.yandex.ru/toloka/doc/concepts/create-tasks-batch-docpage/ """
        if len(args) == 1 and hasattr(args[0], '__iter__'):
            args = args[0]
        response_data = self.uri.POST(
            json=tuple(utils.prepare_json(arg) for arg in args),
            params=self.params
        ).json()
        if self.params.get('async_mode') == 'true':  # it was already converted to string
            return operations.Entity(**response_data)
        else:
            entities = tuple(
                self.entity_class(**data)
                for data in response_data['items'].values()
            )
            if self.params.get('skip_invalid_items') == 'true':
                return entities, response_data['validation_errors']
            else:
                return entities


class Item(base.Item):
    pass


class Entity(entities.Datable, base.Entity):
    DATE_FIELDS = ['created']
