from . import base
from .base import collections
from .base import entities
from .base import items


class Resource(base.Resource):
    def __init__(self, api_root):
        super(Resource, self).__init__(
            uri=getattr(api_root, 'user-skills'),
            collection_class=Collection,
            item_class=Item,
            entity_class=Entity,
        )


class Collection(collections.Creatable, base.Collection):
    create_method = 'PUT'


class Item(items.Deletable, base.Item):
    pass


class Entity(entities.Datable, base.Entity):
    DATE_FIELDS = ['created']
