from django.contrib.postgres.fields import JSONField
from django.db import models

from cars.users.models.user import User


class FakeCar(models.Model):

    plate = models.CharField(max_length=16)
    latitude = models.FloatField()
    longitude = models.FloatField()
    is_free = models.BooleanField()
    model_id = models.IntegerField()
    updated_at = models.DateTimeField()

    class Meta:
        db_table = 'fake_car'

    def __str__(self):
        return str(self.plate)


class FakeOrder(models.Model):

    user = models.ForeignKey(User, on_delete=models.CASCADE)
    car = models.ForeignKey(FakeCar, on_delete=models.CASCADE)
    started_at = models.DateTimeField()
    finished_at = models.DateTimeField(null=True)
    costs = JSONField()

    class Meta:
        db_table = 'fake_order'
