from __future__ import unicode_literals
import datetime

from ..base.car import Car


class AnyTimeCar(Car):

    TARIFFS = {
        'parking': {
            'day': 2.0,
            'night': 0.0,
        },
        'usage': {
            'default': 8.0,
            # 'KIA Rio': 8.0,
            # 'Hyundai Solaris': 6.0,
            # 'BMW 116i': 7.0,
            # 'Renault Kangoo': 6.0,
        }
    }

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['id']

    @classmethod
    def extract_color(cls, raw_data):
        return None

    @classmethod
    def extract_fuel(cls, raw_data):
        return raw_data['fuel']

    @classmethod
    def extract_lat(cls, raw_data):
        return raw_data['coords'][0]

    @classmethod
    def extract_lon(cls, raw_data):
        return raw_data['coords'][1]

    @classmethod
    def extract_model(cls, raw_data):
        return raw_data['name']

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['number']

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        hour = datetime.datetime.utcnow().hour
        tariff_type = 'day' if 6 < hour < 21 else 'night'
        tariff = cls.TARIFFS['parking'][tariff_type]
        return tariff

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        model = cls.extract_model(raw_data)
        tariff = cls.TARIFFS['usage'].get(model)
        if tariff is None:
            tariff = cls.TARIFFS['usage']['default']
        return tariff

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls.TRANSMISSION.AUTOMATIC.value
