from __future__ import unicode_literals
import logging

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import AnyTimeCar


LOGGER = logging.getLogger(__name__)


class AnyTimeFeedConfig(FeedConfig):

    api_token = 'dbc9bde-ccb168aa11-4c7c823200-48164-bedff9a8'
    api_url = 'https://anytimecar.ru/api/yandex/getCars/?k={}'.format(api_token)


class AnyTimeFeed(Feed):

    operator = operators.ANYTIME
    CarClass = AnyTimeCar
    ConfigClass = AnyTimeFeedConfig

    @property
    def request_url(self):
        return self.cfg.api_url

    def _extract_feed(self, response):
        data = response.json()
        feed = data['cars']
        return feed
