# pylint: disable=abstract-method
import copy
import os

import cars.settings


class FeedConfig(object):

    def __init__(self, *args, operator, **kwargs):
        super().__init__(*args, **kwargs)
        self.operator = operator

    @property
    def geocoder_url(self):
        return cars.settings.GEOCODER['url']

    @property
    def push_client_filename(self):
        return os.path.join('logs', '{}.log'.format(self.operator.short_name))

    @property
    def saas(self):
        return cars.settings.CAR_INDEX['SAAS_CONFIG']

    @property
    def sentry_dsn(self):
        return cars.settings.SENTRY['feeds']

    @property
    def solomon(self):
        config = copy.deepcopy(cars.settings.SOLOMON)
        config.update(cars.settings.FEEDS['solomon'])
        config.pop('push_interval')
        return config

    @property
    def yt_locks(self):
        config = cars.settings.YT['locks']
        lock_path = os.path.join(config['base_dir'], 'feeds', self.operator.short_name)
        return {
            'proxy': config['proxy'],
            'token': config['token'],
            'ttl': config['ttl'],
            'path': lock_path,
        }
