# coding: utf-8
from __future__ import unicode_literals
import datetime
import logging

from ..base.car import Car


LOGGER = logging.getLogger(__name__)


class Car5Car(Car):

    _COLOR_MAP = {
        'белый': Car.COLOR.WHITE,
        'серый': Car.COLOR.GRAY,
    }

    TARIFFS = {
        'parking': {
            'day': 2.0,
            'night': 0.0,
        },
    }

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['car_id']

    @classmethod
    def extract_color(cls, raw_data):
        return cls._map_color(raw_data['color'])

    @classmethod
    def extract_fuel(cls, raw_data):
        return float(raw_data['fuel'])

    @classmethod
    def extract_lat(cls, raw_data):
        return float(raw_data['lat'])

    @classmethod
    def extract_lon(cls, raw_data):
        return float(raw_data['lon'])

    @classmethod
    def extract_model(cls, raw_data):
        return raw_data['model']

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['gnum']

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        hour = datetime.datetime.utcnow().hour
        tariff_type = 'day' if 4 < hour < 20 else 'night'
        tariff = cls.TARIFFS['parking'][tariff_type]
        return tariff

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        return float(raw_data['price1m']) / 100

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls.TRANSMISSION.AUTOMATIC.value
