from __future__ import unicode_literals
import logging

import furl

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import Car5Car


LOGGER = logging.getLogger(__name__)


class Car5FeedConfig(FeedConfig):

    api_url = 'https://car5.ru/car5/api/cars/'
    api_session_id = '99fb64f2-1094-4d72-b887-98a2f506feaa'

    @property
    def api_full_url(self):
        url_args = {
            'session_id': self.api_session_id,
        }
        api_full_url = furl.furl(self.api_url).add(args=url_args).url
        return api_full_url


class Car5Feed(Feed):

    operator = operators.CAR5
    CarClass = Car5Car
    ConfigClass = Car5FeedConfig

    tick_interval = '* * * * * */5'

    @property
    def request_url(self):
        return self.cfg.api_full_url

    def _extract_feed(self, response):
        data = response.json()
        cars = data['cars']
        for car in cars:
            if car['model'] == 'Hyundai Solaris AT NEW':
                car['model'] = 'Hyundai Solaris'
        return cars
