# coding: utf-8
from __future__ import unicode_literals
import datetime
import logging

from ..base.car import Car


LOGGER = logging.getLogger(__name__)


class ColesaCar(Car):

    _COLOR_MAP = {
        'Белый': Car.COLOR.WHITE,
        'Голубой': Car.COLOR.BLUE,
        'Желтый': Car.COLOR.YELLOW,
        'Зеленый': Car.COLOR.GREEN,
        'Красный': Car.COLOR.RED,
        'Оранжевый': Car.COLOR.ORANGE,
        'Серебристый': Car.COLOR.GRAY,
        'Синий': Car.COLOR.BLUE,
        'Темно-серый': Car.COLOR.GRAY,
        'Темно-синий': Car.COLOR.BLUE,
        'Чёрный': Car.COLOR.BLACK,
    }

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['id']

    @classmethod
    def extract_color(cls, raw_data):
        return cls._map_color(raw_data['color']['name'])

    @classmethod
    def extract_fuel(cls, raw_data):
        return raw_data['fuel_level_percent']

    @classmethod
    def extract_lat(cls, raw_data):
        return raw_data['latitude']

    @classmethod
    def extract_lon(cls, raw_data):
        return raw_data['longitude']

    @classmethod
    def extract_model(cls, raw_data):
        return raw_data['car_model']['name']

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['number']

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        prices = raw_data['car_model']['car_prices']
        hour = datetime.datetime.utcnow().hour
        if 5 < hour < 19:
            tariff = prices['day_per_minute_wait']['amount']
        else:
            tariff = prices['night_per_minute_wait']['amount']
        tariff = float(tariff) / 100
        return tariff

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        prices = raw_data['car_model']['car_prices']
        hour = datetime.datetime.utcnow().hour
        if 5 < hour < 19:
            tariff = prices['day_per_minute']['amount']
        else:
            tariff = prices['night_per_minute']['amount']
        tariff = float(tariff) / 100
        return tariff

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls.TRANSMISSION.AUTOMATIC.value
