from __future__ import unicode_literals
import logging

import furl

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import ColesaCar


LOGGER = logging.getLogger(__name__)


class ColesaFeedConfig(FeedConfig):
    api_furl = furl.furl('https://colesa.com/api/v2/cars?client_id=cs-ios&client_version=7.7.7')


class ColesaFeed(Feed):

    operator = operators.COLESA
    CarClass = ColesaCar
    ConfigClass = ColesaFeedConfig

    tick_interval = '* * * * * */5'

    @property
    def request_url(self):
        return None

    def _get_feed(self):
        limit = 10000
        offset = 0
        feed = []

        while True:
            slice_resp = self._request_slice(limit, offset)
            feed_slice = self._extract_feed(slice_resp)
            feed.extend(feed_slice)

            pagination = slice_resp.json()['meta']['pagination']
            if pagination['count'] < pagination['limit']:
                break

            limit = pagination['limit']
            offset = pagination['offset'] + pagination['count']

        return feed

    def _request_slice(self, limit, offset):
        url = self._make_slice_url(limit, offset)
        resp = self._request(url=url, headers=self.request_headers)
        return resp

    def _make_slice_url(self, limit, offset):
        args = {
            'limit': limit,
            'offset': offset,
        }
        url = self.cfg.api_furl.copy().add(args=args).url
        return url

    def _extract_feed(self, response):
        data = response.json()
        cars = data['data']
        return cars
