import logging

from cars.aggregator.static_data import cities
from ..generic.rightech import RightechCar


LOGGER = logging.getLogger(__name__)


class DelimobilCar(RightechCar):

    usage_tariff_by_city = {
        cities.MSK.code: 8.0,
        cities.SPB.code: 7.0,
        cities.UFA.code: 7.0,
    }

    @classmethod
    def extract_local_id(cls, raw_data):
        plate_number = cls.extract_plate_number(raw_data)
        plate_number_no_city = plate_number.split('_')[0]
        return plate_number_no_city

    @classmethod
    def extract_color(cls, raw_data):
        return cls.COLOR.GRAY.value

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        return 2.5

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        city_id = cls.extract_city_id(raw_data)
        usage_tariff = cls.usage_tariff_by_city.get(city_id)
        if usage_tariff is None:
            LOGGER.error('Unknown city id: %s', city_id)
            usage_tariff = cls.usage_tariff_by_city[1]
        return usage_tariff
