from ..base.car import Car
from ..generic.cartrek import CartrekCar


class DriveTimeCar(CartrekCar):
    DEFAULT_COLOR = Car.COLOR.BLACK
    TARIFFS = {
        'parking': 0.06,
        'usage': 0.29,
    }

    @classmethod
    def extract_color(cls, raw_data):
        color = super().extract_color(raw_data)
        if not color:
            color = cls.DEFAULT_COLOR.value
        return color
