from __future__ import unicode_literals
import logging

from ..base.car import Car


LOGGER = logging.getLogger(__name__)


class EasyRideCar(Car):

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['id']

    @classmethod
    def extract_color(cls, raw_data):
        return raw_data.get('color')

    @classmethod
    def extract_fuel(cls, raw_data):
        return float(raw_data['data_fuel'])

    @classmethod
    def extract_lat(cls, raw_data):
        return float(raw_data['lat'])

    @classmethod
    def extract_lon(cls, raw_data):
        return float(raw_data['lng'])

    @classmethod
    def extract_model(cls, raw_data):
        return 'Renault Kaptur'

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['numberplate']

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        return 3.0

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        return 12.0

    @classmethod
    def extract_transmission(cls, raw_data):
        return Car.TRANSMISSION.AUTOMATIC.value
