import logging

from cars.aggregator.static_data import operators
from ..base.config import FeedConfig
from ..base.service import Feed
from .car import EasyRideCar


LOGGER = logging.getLogger(__name__)


class EasyRideFeedConfig(FeedConfig):
    api_url = 'https://easyride.cariot.ru/external/cars'


class EasyRideFeed(Feed):

    operator = operators.EASYRIDE
    CarClass = EasyRideCar
    ConfigClass = EasyRideFeedConfig

    @property
    def request_url(self):
        return self.cfg.api_url

    def _extract_feed(self, response):
        return response.json()['data']
