# coding: utf-8
from ...base.car import Car


class CartrekCar(Car):

    _COLOR_MAP = {
        'серый': Car.COLOR.GRAY,
        'красный': Car.COLOR.RED,
        'черный': Car.COLOR.BLACK,
        'светло-голубой': Car.COLOR.BLUE,
    }

    TARIFFS = {
        'parking': 0,
        'usage': 0,
    }

    @classmethod
    def extract_local_id(cls, raw_data):
        return raw_data['Id']

    @classmethod
    def extract_color(cls, raw_data):
        return cls._map_color(raw_data['Color'])

    @classmethod
    def extract_fuel(cls, raw_data):
        return float(raw_data['FuelLevel'])

    @classmethod
    def extract_lat(cls, raw_data):
        return raw_data['Lat']

    @classmethod
    def extract_lon(cls, raw_data):
        return raw_data['Lon']

    @classmethod
    def extract_model(cls, raw_data):
        return '{} {}'.format(raw_data['Brand'], raw_data['Model'])

    @classmethod
    def extract_plate_number(cls, raw_data):
        return raw_data['RegNumber']

    @classmethod
    def extract_parking_tariff(cls, raw_data):
        return cls.TARIFFS['parking']

    @classmethod
    def extract_usage_tariff(cls, raw_data):
        return cls.TARIFFS['usage']

    @classmethod
    def extract_transmission(cls, raw_data):
        return cls.TRANSMISSION.AUTOMATIC.value
