from __future__ import unicode_literals
import datetime
import sys

import furl

from ...base.config import FeedConfig
from ...base.service import Feed


class CartrekFeedConfig(FeedConfig):

    api_url = None  # https://something.cartrek.online/
    api_login = None
    api_password = None
    api_session_lifespan = datetime.timedelta(hours=1)

    @property
    def api_login_url(self):
        return furl.furl(self.api_url).set(path='/profile/signin')

    @property
    def api_cars_url(self):
        return furl.furl(self.api_url).set(path='/api/cars')


class CartrekFeed(Feed):

    operator = None
    CarClass = None
    ConfigClass = None

    @property
    def request_url(self):
        return self.cfg.api_cars_url

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._session_start = None

    def startup(self, *args, **kwargs):  # pylint: disable=arguments-differ
        super().startup(*args, **kwargs)
        self._login()
        self._session_start = datetime.datetime.utcnow()

    def tick(self, *args, **kwargs):  # pylint: disable=arguments-differ
        if datetime.datetime.utcnow() - self._session_start > self.cfg.api_session_lifespan:
            sys.exit(0)
        return super().tick(*args, **kwargs)

    def _login(self):
        payload = {
            'email': self.cfg.api_login,
            'password': self.cfg.api_password,
        }
        self._request(method='POST', url=self.cfg.api_login_url, json=payload)

    def _extract_feed(self, response):
        data = response.json()
        feed = data['cars']
        return feed
